/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import external.AnnotationCommand;
import external.FixLayoutCommand;
import external.PlotCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonRunListener;
import org.autoplot.ScriptContext2023;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.DatasetCommand;
import org.autoplot.jythonsupport.GetDataSetCommand;
import org.autoplot.jythonsupport.GetDataSetsCommand;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.jythonsupport.ui.ScriptPanelSupport;
import org.autoplot.scriptconsole.MakeToolPanel;
import org.das2.system.RequestProcessor;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.PyException;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.jython");
    private static final HashMap<String, String> okayed = new HashMap();

    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox) throws IOException {
        InteractiveInterpreter interp = org.autoplot.jythonsupport.JythonUtil.createInterpreter((boolean)sandbox);
        if (Util.isLegacyImports() && appContext) {
            try (InputStream in = JythonUtil.class.getResource("/appContextImports2025.py").openStream();){
                interp.execfile(in, "/appContextImports2025.py");
            }
        }
        interp.set("monitor", (Object)new NullProgressMonitor());
        interp.set("dataset", (PyObject)new DatasetCommand());
        interp.set("getDataSet", (PyObject)new GetDataSetCommand());
        interp.set("getDataSets", (PyObject)new GetDataSetsCommand());
        return interp;
    }

    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox, Application dom, ProgressMonitor mon) throws IOException {
        InteractiveInterpreter interp = JythonUtil.createInterpreter(appContext, sandbox);
        if (dom != null) {
            interp.set("dom", (Object)dom);
            interp.set("plotx", (PyObject)new PlotCommand(dom));
            interp.set("plot", (PyObject)new PlotCommand(dom));
            interp.set("annotation", (PyObject)new AnnotationCommand(dom));
            interp.set("fixLayout", (PyObject)new FixLayoutCommand(dom));
            if (dom.getController() == null) {
                logger.warning("createInterpreter with dom that does not have a controller, it will not have a scriptContext");
            } else {
                ScriptContext2023 scriptContext = dom.getController().getScriptContext();
                if (scriptContext == null) {
                    logger.warning("createInterpreter with dom that does not have a controller, it will not have a scriptContext");
                } else {
                    interp.set("scriptContext", (PyObject)new PyJavaInstance((Object)scriptContext));
                    Class<?> c = ((Object)((Object)dom.getController().getScriptContext())).getClass();
                    HashSet<String> exclude = new HashSet<String>(Arrays.asList("hashCode"));
                    for (Method m : c.getDeclaredMethods()) {
                        boolean isPublic;
                        if (m.getName().startsWith("_") || exclude.contains(m.getName()) || interp.get(m.getName()) != null || !(isPublic = Modifier.isPublic(m.getModifiers()))) continue;
                        interp.exec("" + m.getName() + "=scriptContext." + m.getName());
                    }
                }
            }
        }
        if (mon != null) {
            interp.set("monitor", (Object)mon);
        } else {
            interp.set("monitor", (Object)new NullProgressMonitor());
        }
        return interp;
    }

    protected static void runScript(ApplicationModel model, String script, String[] argv, String pwd) throws IOException {
        logger.entering("org.autoplot.JythonUtil", "runScript {0}", script);
        try {
            URI scriptURI = DataSetURI.getURI((String)script);
            try (InputStream in = DataSetURI.getInputStream((URI)scriptURI, (ProgressMonitor)new NullProgressMonitor());){
                JythonUtil.runScript(model, in, script, argv, pwd);
            }
        }
        catch (URISyntaxException ex) {
            URL scriptURL = DataSetURI.getURL((String)script);
            try (InputStream in = DataSetURI.getInputStream((URL)scriptURL, (ProgressMonitor)new NullProgressMonitor());){
                JythonUtil.runScript(model, in, script, argv, pwd);
            }
        }
        logger.exiting("org.autoplot.JythonUtil", "runScript {0}", script);
    }

    protected static void runScript(ApplicationModel model, InputStream in, String name, String[] argv, String pwd) throws IOException {
        JythonUtil.runScript(model.getDom(), in, name, argv, pwd);
    }

    public static void runScript(Application dom, InputStream in, String name, String[] argv, String pwd) throws IOException {
        if (argv == null) {
            argv = new String[]{};
        }
        String[] pyInitArgv = new String[argv.length + 1];
        pyInitArgv[0] = name;
        System.arraycopy(argv, 0, pyInitArgv, 1, argv.length);
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), null, (String[])pyInitArgv);
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, (ProgressMonitor)new NullProgressMonitor());
        if (pwd != null) {
            pwd = URISplit.format((URISplit)URISplit.parse((String)pwd));
            interp.exec("PWD='" + pwd + "'");
        }
        interp.exec("import autoplot2025 as autoplot");
        int iargv = 1;
        for (String s : argv) {
            int ieq = s.indexOf(61);
            if (ieq > 0) {
                String snam = s.substring(0, ieq).trim();
                if (DataSourceUtil.isJavaIdentifier((String)snam)) {
                    String sval = s.substring(ieq + 1).trim();
                    interp.exec("autoplot.params['" + snam + "']='" + sval + "'");
                    continue;
                }
                if (snam.startsWith("-")) {
                    System.err.println("\n!!! Script arguments should not start with -, they should be name=value");
                }
                System.err.println("bad parameter: " + snam);
                continue;
            }
            interp.exec("autoplot.params['arg_" + iargv + "']='" + s + "'");
            ++iargv;
        }
        if (name == null) {
            interp.execfile(JythonRefactory.fixImports((InputStream)in));
        } else {
            interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)name), name);
        }
    }

    public static void invokeScriptSoon(URL url) throws IOException {
        JythonUtil.invokeScriptSoon(url, null, (ProgressMonitor)new NullProgressMonitor());
    }

    public static void invokeScriptSoon(URI uri) throws IOException {
        JythonUtil.invokeScriptSoon(uri, null, (ProgressMonitor)new NullProgressMonitor());
    }

    public static void invokeScriptSoon(URL url, Application dom, ProgressMonitor mon) throws IOException {
        JythonUtil.invokeScriptSoon(url, dom, new HashMap<String, String>(), false, false, mon);
    }

    public static void invokeScriptSoon(URI uri, Application dom, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse((URI)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        JythonUtil.invokeScriptSoon(split.resourceUri, dom, (Map<String, String>)params, false, false, mon);
    }

    private static boolean isScriptOkayed(String filename, String contents) {
        String okayedContents = okayed.get(filename);
        if (okayedContents == null) {
            File lastVersionDir = Paths.get(AutoplotSettings.settings().resolveProperty("autoplotData"), "scripts").toFile();
            File lastVersionFile = Paths.get(lastVersionDir.toString(), String.format("%010d.jy", Math.abs((long)filename.hashCode())).trim()).toFile();
            if (lastVersionFile.exists()) {
                try {
                    String lastVersionContents = FileUtil.readFileToString((File)lastVersionFile);
                    if (lastVersionContents.equals(contents)) {
                        logger.log(Level.FINE, "matches file previously okayed: {0}", lastVersionFile);
                        return true;
                    }
                    logger.log(Level.FINE, "does not match file previously run: {0}", lastVersionFile);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            } else {
                logger.log(Level.FINE, "not been run before: {0}", lastVersionFile);
            }
        }
        return contents.equals(okayedContents);
    }

    private static String stripTrailingWhitespace(String param) {
        int len;
        for (len = param.length(); len > 0 && Character.isWhitespace(param.charAt(len - 1)); --len) {
        }
        return param.substring(0, len);
    }

    private static List<String> splitAndTrimLines(String src) {
        String[] ss = src.split("\n");
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = JythonUtil.stripTrailingWhitespace(ss[i]);
        }
        return Arrays.asList(ss);
    }

    private static Patch<String> diffToOkayedScript(String filename, String contents) {
        String okayedContents = okayed.get(filename);
        if (okayedContents == null) {
            File lastVersionDir = Paths.get(AutoplotSettings.settings().resolveProperty("autoplotData"), "scripts").toFile();
            File lastVersionFile = Paths.get(lastVersionDir.toString(), String.format("%010d.jy", Math.abs((long)filename.hashCode())).trim()).toFile();
            if (lastVersionFile.exists()) {
                try {
                    String lastVersionContents = FileUtil.readFileToString((File)lastVersionFile);
                    return DiffUtils.diff(JythonUtil.splitAndTrimLines(lastVersionContents), JythonUtil.splitAndTrimLines(contents));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            } else {
                logger.log(Level.FINE, "not been run before: {0}", lastVersionFile);
                return null;
            }
        }
        return DiffUtils.diff((String)okayedContents, (String)contents);
    }

    public static int showScriptDialog(Component parent, Map<String, Object> env, File file, Map<String, String> fparams, boolean makeTool, URI resourceUri) throws IOException {
        Patch<String> p;
        ParametersFormPanel.FormData fd;
        if (!EventQueue.isDispatchThread()) {
            System.err.println("*** called from off of event thread!!!");
        }
        JPanel paramsPanel = new JPanel();
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 1));
        paramsPanel.setAlignmentX(0.0f);
        ParametersFormPanel fpf = new ParametersFormPanel();
        try {
            fd = fpf.doVariables(env, file, fparams, paramsPanel);
        }
        catch (PySyntaxError ex) {
            System.err.println("pse: " + (Object)((Object)ex));
            fd = new ParametersFormPanel.FormData();
            fd.count = 0;
        }
        if (fd.count == 0 && !makeTool) {
            return 0;
        }
        JPanel scriptPanel = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        EditorTextPane textArea = new EditorTextPane();
        String theScript = EditorTextPane.loadFileToString((File)file);
        try {
            textArea.loadFile(file);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        ScriptPanelSupport support = new ScriptPanelSupport(textArea);
        support.setReadOnly();
        JScrollPane script = new JScrollPane((Component)textArea);
        script.setMinimumSize(new Dimension(640, 380));
        script.setPreferredSize(new Dimension(640, 380));
        scriptPanel.add((Component)script, "Center");
        scriptPanel.add((Component)new JLabel("<html>Run the script:<br>" + file), "North");
        tabbedPane.add((Component)scriptPanel, "script");
        JScrollPane params = new JScrollPane(paramsPanel);
        params.setMinimumSize(new Dimension(640, 480));
        tabbedPane.add((Component)params, "params");
        boolean scriptOkay = JythonUtil.isScriptOkayed(file.toString(), theScript);
        if (!scriptOkay && (p = JythonUtil.diffToOkayedScript(file.toString(), theScript)) != null) {
            textArea.getDocument();
            Runnable run = () -> support.annotatePatch(p);
            SwingUtilities.invokeLater(run);
        }
        if (makeTool) {
            if (scriptOkay) {
                tabbedPane.setSelectedIndex(1);
            } else {
                tabbedPane.setSelectedIndex(0);
            }
        } else {
            tabbedPane.setSelectedIndex(1);
        }
        JPanel theP = new JPanel(new BorderLayout());
        theP.add((Component)tabbedPane, "Center");
        MakeToolPanel makeToolPanel = null;
        if (makeTool) {
            makeToolPanel = new MakeToolPanel(scriptOkay);
            theP.add((Component)makeToolPanel, "South");
        } else if (scriptOkay) {
            theP.add((Component)new JLabel("You have run this version of the script before."), "South");
        } else {
            JLabel trustedScriptLabel = new JLabel("Make sure this script does not contain malicious code.");
            trustedScriptLabel.setIcon(AutoplotUI.WARNING_ICON);
            theP.add((Component)trustedScriptLabel, "South");
        }
        int result = AutoplotUtil.showConfirmDialog2(parent, theP, "Run Script " + file.getName(), 2);
        if (result == 0) {
            fd = fpf.getFormData();
            ParametersFormPanel.resetVariables((ParametersFormPanel.FormData)fd, fparams);
            if (makeTool) {
                assert (makeToolPanel != null);
                if (makeToolPanel.isInstall()) {
                    if (parent instanceof AutoplotUI) {
                        ((AutoplotUI)parent).installTool(file, resourceUri);
                        ((AutoplotUI)parent).reloadTools();
                    } else {
                        throw new RuntimeException("Unable to install");
                    }
                }
            }
            okayed.put(file.toString(), theScript);
        }
        return result;
    }

    public static int invokeScriptSoon(URL url, Application dom, Map<String, String> params, boolean askParams, boolean makeTool, ProgressMonitor mon1) throws IOException {
        try {
            return JythonUtil.invokeScriptSoon(url.toURI(), dom, params, askParams, makeTool, null, mon1);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int invokeScriptSoon(URI uri, Application dom, Map<String, String> vars, boolean askParams, boolean makeTool, ProgressMonitor mon1) throws IOException {
        return JythonUtil.invokeScriptSoon(uri, dom, vars, askParams, makeTool, null, mon1);
    }

    public static int invokeScriptSoon(final URI uri, final Application dom, final Map<String, String> params, final boolean askParams, final boolean makeTool, final JythonRunListener runListener, final ProgressMonitor mon1) throws IOException {
        if (EventQueue.isDispatchThread()) {
            logger.warning("THIS IS THE EVENT THREAD, AND ATTEMPTS TO DOWNLOAD A FILE.");
        }
        final File file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        final ArrayList<Exception> result = new ArrayList<Exception>();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    result.add(JythonUtil.invokeScriptSoon(uri, file, dom, params, askParams, makeTool, runListener, mon1));
                }
                catch (IOException ex) {
                    result.add(ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                result.add(ex);
            }
        }
        Object result0 = result.get(0);
        if (result0 instanceof IOException) {
            throw (IOException)result0;
        }
        if (result0 instanceof RuntimeException) {
            throw (RuntimeException)result0;
        }
        if (result0 instanceof Exception) {
            throw new RuntimeException((Exception)result0);
        }
        return (Integer)result.get(0);
    }

    public static void invokeScriptNow(Map<String, Object> environ, File file) throws IOException, PyException {
        ProgressMonitor mon = (ProgressMonitor)environ.get("monitor");
        if (mon == null) {
            logger.log(Level.FINE, "creating NullProgressMonitor to run {0}", file);
            mon = new NullProgressMonitor();
        }
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, (Application)environ.get("dom"), mon);
        for (Map.Entry<String, Object> e : environ.entrySet()) {
            interp.set(e.getKey(), e.getValue());
        }
        try (FileInputStream in = new FileInputStream(file);){
            File lastVersionDir = Paths.get(AutoplotSettings.settings().resolveProperty("autoplotData"), "scripts").toFile();
            if (!lastVersionDir.exists()) {
                if (!lastVersionDir.mkdirs()) {
                    logger.log(Level.WARNING, "unable to mkdir {0}", lastVersionDir);
                } else {
                    File readme = new File(lastVersionDir, "README.txt");
                    try (PrintStream out = new PrintStream(readme);){
                        out.print("Files here have been okayed to run and can be run again without a warning.  See https://autoplot.org/1310\n");
                    }
                }
            }
            File lastVersionFile = Paths.get(lastVersionDir.toString(), String.format("%010d.jy", Math.abs((long)file.toString().hashCode())).trim()).toFile();
            FileUtil.fileCopy((File)file, (File)lastVersionFile);
            interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)file.getName()), file.toString());
        }
        catch (PyException ex) {
            throw ex;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
    }

    public static int invokeScriptSoon(URI uri, File file, final Application dom, Map<String, String> params, boolean askParams, boolean makeTool, JythonRunListener jythonRunListener, ProgressMonitor mon1) throws IOException {
        ParametersFormPanel.FormData fd;
        Object mon = mon1 == null ? new NullProgressMonitor() : mon1;
        Map<String, String> fparams = params == null ? new HashMap<String, String>() : params;
        ParametersFormPanel pfp = new ParametersFormPanel();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("dom", dom);
        URISplit split = URISplit.parse((URI)uri);
        env.put("PWD", split.path);
        int response = 0;
        if (askParams) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("dom", dom);
            args.put("PWD", split.path);
            JPanel paramPanel = new JPanel();
            try {
                fd = pfp.doVariables(env, file, params, paramPanel);
            }
            catch (PySyntaxError ex) {
                AutoplotUtil.showMessageDialog((Component)dom.getController().getDasCanvas(), "<html>The script has a syntax error which prevents use in the address bar.<br>(Note Autoplot runs a subset of the code and may introduce problems.)", "Syntax Error", 0);
                return 2;
            }
            AutoplotUI parent = dom.getController().maybeGetApplicatonGUI();
            if (parent == null) {
                parent = dom.getController().getDasCanvas();
            }
            response = JythonUtil.showScriptDialog(parent, args, file, fparams, makeTool, uri);
        } else {
            fd = pfp.doVariables(env, file, params, null);
        }
        if (response == 0) {
            Runnable run = new Runnable((ProgressMonitor)mon, uri, fparams, fd, jythonRunListener, file){
                final /* synthetic */ ProgressMonitor val$mon;
                final /* synthetic */ URI val$uri;
                final /* synthetic */ Map val$fparams;
                final /* synthetic */ ParametersFormPanel.FormData val$fd;
                final /* synthetic */ JythonRunListener val$jythonRunListener;
                final /* synthetic */ File val$file;
                {
                    this.val$mon = progressMonitor;
                    this.val$uri = uRI;
                    this.val$fparams = map;
                    this.val$fd = formData;
                    this.val$jythonRunListener = jythonRunListener;
                    this.val$file = file;
                }

                @Override
                public void run() {
                    try {
                        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, this.val$mon);
                        logger.log(Level.FINE, "invokeScriptSoon({0})", this.val$uri);
                        for (Map.Entry p : this.val$fparams.entrySet()) {
                            try {
                                this.val$fd.implement((PythonInterpreter)interp, (String)p.getKey(), (String)p.getValue());
                            }
                            catch (ParseException ex) {
                                logger.log(Level.WARNING, null, ex);
                            }
                        }
                        URISplit split = URISplit.parse((URI)this.val$uri);
                        interp.set("dom", (Object)dom);
                        interp.set("PWD", (Object)split.path);
                        if (this.val$jythonRunListener != null) {
                            this.val$jythonRunListener.runningScript(this.val$file);
                        }
                        try (FileInputStream in = new FileInputStream(this.val$file);){
                            File lastVersionDir = Paths.get(AutoplotSettings.settings().resolveProperty("autoplotData"), "scripts").toFile();
                            if (!lastVersionDir.exists()) {
                                if (!lastVersionDir.mkdirs()) {
                                    logger.log(Level.WARNING, "unable to mkdir {0}", lastVersionDir);
                                } else {
                                    File readme = new File(lastVersionDir, "README.txt");
                                    try (PrintStream out = new PrintStream(readme);){
                                        out.print("Files here have been okayed to run and can be run again without a warning.  See http://autoplot.org/1310\n");
                                    }
                                }
                            }
                            File lastVersionFile = Paths.get(lastVersionDir.toString(), String.format("%010d.jy", Math.abs((long)this.val$file.toString().hashCode())).trim()).toFile();
                            FileUtil.fileCopy((File)this.val$file, (File)lastVersionFile);
                            interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)this.val$file.getName()), this.val$uri.toString());
                        }
                        catch (PyException ex) {
                            if (this.val$jythonRunListener != null) {
                                this.val$jythonRunListener.exceptionEncountered(this.val$file, ex);
                            }
                            throw ex;
                        }
                        finally {
                            if (!this.val$mon.isFinished()) {
                                this.val$mon.finished();
                            }
                            if (this.val$jythonRunListener != null) {
                                this.val$jythonRunListener.runningScript(null);
                            }
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            RequestProcessor.invokeLater((Runnable)run);
        }
        return response;
    }

    public static void invokeScript20181217(URI uri, File file, Application dom, Map<String, String> fparams, ProgressMonitor mon) throws IOException {
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (file == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalArgumentException("invokeScript called from EventQueue");
            }
            file = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        }
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, mon);
        ParametersFormPanel pfp = new ParametersFormPanel();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("dom", dom);
        URISplit split = URISplit.parse((URI)uri);
        env.put("PWD", split.path);
        ParametersFormPanel.FormData fd = pfp.doVariables(env, file, fparams, null);
        logger.log(Level.FINE, "invokeScriptSoon({0})", uri);
        for (Map.Entry<String, String> p : fparams.entrySet()) {
            try {
                fd.implement((PythonInterpreter)interp, p.getKey(), p.getValue());
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        interp.set("dom", (Object)dom);
        interp.set("PWD", (Object)split.path);
        try (FileInputStream in = new FileInputStream(file);){
            interp.execfile(JythonRefactory.fixImports((InputStream)in, (String)file.getName()), uri.toString());
        }
        catch (PyException ex) {
            throw ex;
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
    }
}

